//======================================================== FX_MEMORY_MAP
;
;
//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
STAR_QTY	EQU	18
BUFF_Y		EQU	44
BUFFSZ		EQU	32 * BUFF_Y	;1280
BUFF1A		EQU	#8000 - BUFFSZ
BUFF1B		EQU	BUFF1A - BUFFSZ
BUFF2A		EQU	BUFF1B - BUFFSZ
BUFF2B		EQU	BUFF2A - BUFFSZ
;---
C0	EQU	0;
CZ	EQU	3;
C1	EQU	3;
C2	EQU	4;
C3	EQU	5;
C4	EQU	8;
C5	EQU	14;
;---
P7FFD	EQU #7FFD
XOR8	EQU #08
PG18	EQU #18
;---
ADDLN0	EQU 64-2
ADDLN1	EQU 64-2
ADDLN2	EQU 64-3
ADDLN3	EQU 64-3
ADDLN4	EQU 64-3
ADDLN5	EQU 64-1
;---
ADDLN0X	EQU 64-1
ADDLN1X	EQU 64-3
ADDLN2X	EQU 64-3
ADDLN3X	EQU 64-3
ADDLN4X	EQU 64-2
ADDLN5X	EQU 64-2
;---
STARS_LIST_QTY_MAX EQU 0
STEP_Z	EQU	1
Z_MAX	EQU	16
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	LD	A,#17
	CALL	PAGER

	LD	HL,#4000
	LD	DE,#4001
	LD	(HL),#F0
	LD	BC,6143
	LDIR

	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR

	LD	HL,BUFF2B
	LD	DE,BUFF2B + 1
	LD	BC,BUFFSZ*4-1
	LD	(HL),0
	LDIR

	LD	HL,BUFF
	LD	DE,BUFF + 1
	LD	BC,64 * BUFF_Y - 1
	LD	(HL),0
	LDIR

	CALL	SWAPBUFF
	CALL	SWP
;-----------------------
INIMOVE
	LD	HL,MOVE_ADR
	LD	DE,#5820
	LD	LX,BUFF_Y
INIMV0	;---
	LD	BC,0-32
INIMV2	;---
	LD	A,16
INIMV1	;---
	LD	(HL),#E1	; pop hl
	INC	HL
	LD	(HL),#22	; ld (adr),hl
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	DE
	DEC	A
	JP	NZ,INIMV1
	;---
	;#40 = 0100.0000
	;#c0 = 1100.0000

	LD	A,D
	XOR	#80
	LD	D,A
	AND	#80
	JP	Z,INIMV3
	;---
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
INIMV3	;---
	DEC	LX
	JP	NZ,INIMV2
	;---
	LD	(HL),#EB	; ex de,hl
	INC	HL
	LD	(HL),#E9	; jp (hl)
	INC	HL
	;---
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	XOR A:OUT (#FE),A
	CALL	MOVE_TOP
	LD	LX,14
	CALL	OUTPUT
	CALL	SWP
	LD A,2:OUT (#FE),A
	CALL	ROTATE
	LD A,1:OUT (#FE),A
	;-----
	EI
	HALT
	XOR A:OUT (#FE),A
	CALL	MOVE_TOP
	LD	LX,15
	CALL	OUTPUT
	CALL	SWP
	
	;-----
	EI
	HALT
	XOR A:OUT (#FE),A
	CALL	MOVE_TOP
	LD	LX,15
	CALL	OUTPUT
	CALL	SWP
	
	;-----
	EI
	HALT
	XOR A:OUT (#FE),A
	CALL	MOVE_TOP
	CALL	ADDSTARS
	;LD A,4:OUT (#FE),A
	
	CALL	SWAPBUFF
	CALL	SWP
	
	;-----
	RET
//======================================================== FX_PROCEDURES
SWAPBUFF
	LD	HL,BUFF+2
	LD	(OUT_BUFF),HL
	;-
	LD	A,0
SWAPBUFFA EQU $-1
	XOR	#FF
	LD	(SWAPBUFFA),A
	JR	Z,SWAPBUFF1
	;---
	LD	HL,BUFF2A + BUFFSZ - 1
	LD	(OUT_BUFFA),HL
	LD	HL,BUFF2B + BUFFSZ
	LD	(OUT_BUFFB),HL
	LD	HL,BUFF1A
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF1B
	LD	(SWP_BUFFB),HL
	RET
SWAPBUFF1 ;---
	LD	HL,BUFF1A + BUFFSZ - 1
	LD	(OUT_BUFFA),HL
	LD	HL,BUFF1B + BUFFSZ
	LD	(OUT_BUFFB),HL
	LD	HL,BUFF2A
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF2B
	LD	(SWP_BUFFB),HL
	RET
;--------------------------
SWP	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	LD	HL,0
SWP_BUFFA EQU $-2
	JP	Z,SWP1
	LD	HL,0
SWP_BUFFB EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL
	RET
;--------------------------
MOVE_TOP
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;---
	LD	(SOHRSP1),SP
	LD	SP,0
MOVE_TOP_SP	EQU	$-2
	LD	DE,MOVE_TOP1
	JP	MOVE_ADR
MOVE_TOP1
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;----------------------
OUTPUT	;--
	LD	A,31
	DEC	A
	JP	NZ,$-1
	;--
	LD	(SOHRSP_DEC),SP
	LD	H,PALETTE / 256
	LD	DE,0
OUT_BUFFA EQU $-2
	LD	SP,0
OUT_BUFFB EQU $-2
	EXX
	LD	HL,BUFF
OUT_BUFF EQU $-2
	LD	D,TBL_SUB / 256
	LD	BC,P7FFD
	LD	A,PG18
	OUT	(C),A
	;-
OUTLP	EX	AF,AF
	;--------
	DUP	2
	;--------
	DUP	6
	;--------
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	EXX		;4 /52 //77 /=>143
	;--------
	EDUP
	;-------- 143*6=858
	;- wait 11
	XOR A:RET NZ
	;--- swap scr
	EX	AF,AF	;4
	XOR	XOR8	;7
	OUT	(C),A	;12
	EX	AF,AF	;4 /27
	;--------
	EDUP
	;-------- 24 chars completed
	DUP	3
	;--------
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	EXX		;4 /52 //77 /=>143
	;--------
	EDUP
	;-------- 		/143*3=429
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /25
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	E	;4
	INC	H	;4
	LD	B,(HL)	;7
	EXX		;4 /41 //66
	;-----
	LD	E,(HL)	;7
	LD	A,(DE)	;7
	LD	(HL),A	;7 /21
	;-
	EXX		;4
	LD	L,A	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	DEC	H	;4
	LD	A,(HL)	;7
	LD	(DE),A	;7
	DEC	DE	;6
	EXX		;4 /54 //75 /=>141
	;- wait
	LD	A,17
	DEC	A
	JP	NZ,$-1
	RET	NZ
	NOP
	;-- next line
	LD	BC,33	;10
	ADD	HL,BC	;15
	LD	BC,P7FFD ;10
	;--- swap scr
	EX	AF,AF	;4
	XOR	XOR8	;7
	OUT	(C),A	;12 /23
	;--
	DEC	LX	;8
	JP	NZ,OUTLP ;10 /18
	;---
	LD	(OUT_BUFF),HL
	EXX
	LD	(OUT_BUFFA),DE
	LD	HL,0 - BUFFSZ + 1
	ADD	HL,DE
	LD	(OUT_BUFFB),HL
	;---
	LD	SP,0
SOHRSP_DEC EQU $-2
	RET
;------------------------------
ADDSTARS
	LD	A,32
	DEC	A
	JP	NZ,$-1
	;--
	LD	BC,#7FFD	;10
	LD	DE,#1F17	;10
	OUT	(C),D
	EXX			;4
	LD	D,TBL_ADD_HI / 256 ;7
	LD	H,TBL_ADD / 256	;7
	;--
	LD	(SOHRSP2),SP
	LD	SP,ADDSTARS_TBL
	;-
	RET
ADDSTARS_RET
	LD	SP,0
SOHRSP2	EQU $-2
	RET
;-------------------------
ADDSTARS_TBL
	DUP	STAR_QTY
	DW	ADDSTAR
	DW	BUFF + 10
	EDUP
	DW	ADDSTARS_RET
;--------------------------------------
; Начальные координаты точек хранятся в формате 
; X=X+COR_Z 
; Y=Y+COR_Z 
; Z=Z+COR_Z 
; (т.е. с прибавленным смещением до начала таблиц)
;---------------------------------------- 
; Диапазон изменения угла вращения 0..127 
; Поворот осуществляется вокруг осей Ox,Oy 
; по адресу Ay - угол вращения вокруг Oy 
; по адресу Ax - угол вращения вокруг Ox
;---------------------------------------- 
; Таблица произведений: 
;        #C000          +128	   +212	
;        +--------------+----------+----------+ 
;   Coord| Coord*cos(A) | projectY | projectX | Z
;        +--------------+----------+----------+ 
;        Alpha          
;---------------------------------------- 
; Формулы вращения 
;-Ox: 
; y` = y*cos(Ax) - z*sin(Ax) 
; z` = y*sin(Ax) + z*cos(Ax) 
;-Oy: 
; x` = x*cos(Ay) + z*sin(Ay) 
; z` = z*cos(Ay) - x*sin(Ay)

XYZMAX	EQU	21	; максимальная длина по осям (в одну сторону) 
COR_TBL	EQU	#C0
COR_Z	EQU	COR_TBL + XYZMAX 
PROJ_PY EQU	128	;#80
PROJ_PX EQU	212	;#D4

CSDIV	EQU	COR_TBL + XYZMAX*2

COS_AX	EQU	0
SIN_AX	EQU	COS_AX + 32
COS_AY	EQU	0
SIN_AY	EQU	COS_AY + 32


ANGLE_AX_STEP	EQU  700;700;796;896
ANGLE_AY_STEP	EQU  300;300;341;384


ROTATE	;------------------------
	LD	A,#18
	CALL	PAGER
	;-----------------------
	LD	HL,0
ANGLE_AX EQU $-2
	LD	BC,ANGLE_AX_STEP
	ADD	HL,BC
	LD	(ANGLE_AX),HL
	LD	A,H
	AND	127
	LD	(CAX1 + 1),A
	LD	(CAX2 + 1),A
	ADD	A,32
	AND	127
	LD	(SAX1 + 1),A
	LD	(SAX2 + 1),A
	;-----------------------
	LD	HL,0
ANGLE_AY EQU $-2
	LD	BC,ANGLE_AY_STEP
	ADD	HL,BC
	LD	(ANGLE_AY),HL
	LD	A,H
	AND	127
	LD	(CAY1 + 1),A
	LD	(CAY2 + 1),A
	ADD	A,32
	AND	127
	LD	(SAY1 + 1),A
	LD	(SAY2 + 1),A
	;-----------------------
	LD	(ROT_SOHR_SP),SP
	LD	SP,POINTS
	LD	BC,ADDSTARS_TBL
	EXX
	LD	LX,STAR_QTY
ROT1	;------
	POP	BC	;10	координаты C=z B=y
	;---------------------- Ox: y` = y*cos(Ax) - z*sin(Ax) 
CAX1	LD	L,COS_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*cos(Ax)
SAX1	LD	L,SIN_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	SUB	(HL)		;7 a=y`
	;---
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,A
	ADD	A,PROJ_PY	;A = таблица проекции Y
	EXX
	LD	L,A
	EXX
	;---------------------- Ox: z` = y*sin(Ax) + z*cos(Ax) 
SAX2	LD	L,SIN_AX	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=y*sin(Ax)
CAX2	LD	L,COS_AX	;7
	LD	H,C		;4 (hl)=z*sin(Ax)
	ADD	A,(HL)		;7 a=z`
	;---
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,COR_TBL
	;----------------------
	POP	BC
	DEC	SP
	LD	B,A		; координаты C=x B=z
	;---------------------- Oy: x` = x*cos(Ay) + z*sin(Ay)
SAY1	LD	L,SIN_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*sin(Ay)
CAY1	LD	L,COS_AY	;7
	LD	H,C		;4 (hl)=x*cos(Ay)
	ADD	A,(HL)		;7 a=x`
	;--
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	ADD	A,PROJ_PX ; a = projectX
	EX	AF,AF
	;---------------------- Oy: z` = z*cos(Ay) - x*sin(Ay)
CAY2	LD	L,COS_AY	;7
	LD	H,B		;4
	LD	A,(HL)		;7 a=(hl)=z*cos(Ay)
SAY2	LD	L,SIN_AY	;7
	LD	H,C		;4 (hl)=x*sin(Ay)
	SUB	(HL)		;7 a=z`
	;--
	ADD	A,XYZMAX*4
	RRA
	RRA
	AND	%00111111
	LD	L,A		;4
	;----------------------- get buff adr
	EXX
	ADD	A,COR_TBL
	LD	H,A		;H = z
	LD	E,(HL)
	INC	L
	LD	D,(HL)		;DE = BUFF ADR by Py
	EX	AF,AF
	LD	L,A
	LD	A,(HL)		;L = Px
	EX	AF,AF
	LD	A,(HL)		;L = Px
	RRA
	AND	%01111111
	LD	L,A
	LD	H,0
	ADD	HL,DE
	LD	DE,0 - 8 + 64*8
	ADD	HL,DE

	LD	DE,ADDSTAR
	EX	AF,AF
	AND	1
	JP	Z,ROTSZ
	LD	DE,ADDSTARX
ROTSZ
	LD	A,E
	LD	(BC),A
	INC	BC
	LD	A,D
	LD	(BC),A
	INC	BC


	LD	A,L
	LD	(BC),A
	INC	BC
	LD	A,H
	LD	(BC),A
	INC	BC

	EXX
	;------------------------ get spr size
	DEC	LX
	JP	NZ,ROT1
	;---
	LD	SP,0
ROT_SOHR_SP EQU $-2
	RET

	
	
//======================================================== FX_INCLUDE_DATA
ADDSTAR
	INCLUDE "bin/addstar.asm"
ADDSTARX
	INCLUDE "bin/addstarx.asm"
//======================================================== FX_TABLES
	ALIGN	256
PALETTE
	INCBIN "bin/3d_addlight_palette.bin"
;----------------------
TBL_SUB
	INCBIN "bin/tbl_sub.bin"
;----------------------
TBL_ADD
	DB 0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15
	DS 256-16, 15
;----------------------
TBL_ADD_HI
	INCBIN "bin/tbl_add_hi.bin"
;----------------------
POINTS	;z y x
	DB	0+COR_Z,-7+COR_Z,-18+COR_Z
	DB	0+COR_Z,-18+COR_Z,7+COR_Z
	DB	-19+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,-5+COR_Z,-12+COR_Z
	DB	0+COR_Z,-12+COR_Z,5+COR_Z
	DB	-13+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,-2+COR_Z,-6+COR_Z
	DB	0+COR_Z,-6+COR_Z,2+COR_Z
	DB	-6+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,2+COR_Z,6+COR_Z
	DB	0+COR_Z,6+COR_Z,-2+COR_Z
	DB	7+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,5+COR_Z,12+COR_Z
	DB	0+COR_Z,12+COR_Z,-5+COR_Z
	DB	13+COR_Z,0+COR_Z,0+COR_Z
	DB	0+COR_Z,7+COR_Z,18+COR_Z
	DB	0+COR_Z,18+COR_Z,-7+COR_Z
	DB	20+COR_Z,0+COR_Z,0+COR_Z

;----------------------
	ALIGN 256
BUFF	EQU	$ + 64*16
MOVE_ADR EQU	#DB00


	DISPLAY "-------------------------------- FX VARS:"
	DISPLAY "MOVE_ADR ", /A, MOVE_ADR
	DISPLAY "MOVE_ADR SIZE", /A, 32*BUFF_Y*4
	DISPLAY "MOVE_ADR_END ", /A, MOVE_ADR + 32*BUFF_Y*4

	DISPLAY "BUFF END: ", /A, BUFF + 64*40 + 64*8
	DISPLAY "BUFF2B: ", /A, BUFF2B



